<?php


/**
 * Plugin Name: CHG - COTI ADA Pay - WooCommerce Payments
 * Author Name: Carlhenry Global
 * Author URI: https://adapay.finance
 * Description: This WordPress plugin will allow you to create unique customized ADA Payment on WordPress.
 * Version: 1.1.0
*/ 


if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) return;

add_action( 'plugins_loaded', 'ada_payment_init', 11 );

function ada_payment_init() {

    if( class_exists( 'WC_Payment_Gateway' ) ) {
        class WC_Ada_pay_Gateway extends WC_Payment_Gateway {
            public function __construct() {

                $this->id   = 'ada_payment';
                $this->uuid = '123';
                $this->icon = apply_filters( 'woocommerce_ada_icon','https://sandbox.adapay.finance/images/pay-with-ada.svg');
                $this->has_fields = false;
                $this->method_title = __( 'ACHG - COTI ADA Pay - WooCommerce Payments', 'ada-pay-woo');
                $this->method_description = __( 'This WordPress plugin will allow you to create unique customized ADA PAY on WordPress.', 'ada-pay-woo');

                $this->title = $this->get_option( 'title' );
                $this->description = $this->get_option( 'description' );
                $this->instructions = $this->get_option( 'instructions', $this->description );

                $this->init_form_fields();
                $this->init_settings();

                add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
               
                //add_filter( "woocommerce_admin_settings_sanitize_option_wc_my_input", 'filter_woocommerce_admin_settings_sanitize_option_wc_my_input', 10, 3 ); 
                // add_action( 'woocommerce_thank_you_' . $this->id, array( $this, 'thank_you_page' ) );
            }

            public function init_form_fields() {


                $this->form_fields = apply_filters( 'woo_ada_pay_fields', array(
                    'sandbox' => array(
                        'title' => __( 'Enable Sandbox', 'ada-pay-woo'),
                        'type' => 'checkbox',
                        'label' => __( 'Please checked for sandbox details', 'ada-pay-woo'),
                        'default' => 'no'
                    ),
                    'title' => array(
                        'title' => __( 'ADA PAY Title', 'ada-pay-woo'),
                        'type' => 'text',
                        'default' => __( 'ADA PAY', 'ada-pay-woo'),
                        'desc_tip' => true,
                        'description' => __( 'Add a new title for the ADA PAY that customers will see when they are in the checkout page.', 'ada-pay-woo')
                    ),
                    'description' => array(
                        'title' => __( 'ADA PAY Description', 'ada-pay-woo'),
                        'type' => 'textarea',
                        'default' => __( 'Please remit your payment to the shop to allow for the delivery to be made', 'ada-pay-woo'),
                        'desc_tip' => true,
                        'description' => __( 'Add a new title for the ADA PAY that customers will see when they are in the checkout page.', 'ada-pay-woo')
                    ),
                    // 'instructions' => array(
                    //     'title' => __( 'Instructions', 'noob-pay-woo'),
                    //     'type' => 'textarea',
                    //     'default' => __( 'Default instructions', 'noob-pay-woo'),
                    //     'desc_tip' => true,
                    //     'description' => __( 'Instructions that will be added to the thank you page and odrer email', 'noob-pay-woo')
                    // ),
                    'Api_key' => array(
                        'name' => __('My Input', 'woocommerce-my-custom-tab'),
                        'title' => __( 'ADA PAY API KEY', 'ada-pay-woo'),
                        'type' => 'text',
                        'custom_attributes' => array( 'required' => 'required' ),
                        //'id' => 'wc_my_input'

                        //'id' => 'wc_my_input'
                        
                        //'default' => __( 'Noob Payments Gateway', 'noob-pay-woo'),
                        //'desc_tip' => true,
                        //'description' => __( 'Add a new title for the Noob Payments Gateway that customers will see when they are in the checkout page.', 'noob-pay-woo')
                    ),
                    'url' => array(
                        'title' => __( 'ADA PAY Url', 'ada-pay-woo'),
                        'type' => 'url',
                        'placeholder'=>'https://',
                        'custom_attributes' => array( 'required' => 'required' ),

                        //'default' => __( 'Noob Payments Gateway', 'noob-pay-woo'),
                        //'desc_tip' => true,
                        //'description' => __( 'Add a new title for the Noob Payments Gateway that customers will see when they are in the checkout page.', 'noob-pay-woo')
                    ),
                    'expirationTime' => array(
                        'title' => __( 'Payment Expiration Time (in Minutes)', 'ada-pay-woo'),
                        'type' => 'number',
                        'custom_attributes' => array( 'required' => 'required' ),
                        //'default' => __( 'Noob Payments Gateway', 'noob-pay-woo'),
                        //'desc_tip' => true,
                        //'description' => __( 'Add a new title for the Noob Payments Gateway that customers will see when they are in the checkout page.', 'noob-pay-woo')
                    ),
                    // 'enable_for_virtual' => array(
                    //     'title'   => __( 'Accept for virtual orders', 'woocommerce' ),
                    //     'label'   => __( 'Accept COD if the order is virtual', 'woocommerce' ),
                    //     'type'    => 'checkbox',
                    //     'default' => 'yes',
                    // ),
                ));

             

                // $errors = new WP_Error();
                // if ( isset( $Api_key ) && $Api_key == '' ) {
                //   $errors->add( 'cheater', 'Sorry, this field should not be filled. Are you trying to cheat?' );
                // }
            }

          

            public function process_payment( $order_id ) {
                $order = wc_get_order( $order_id );

                $available_gateways = WC()->payment_gateways->get_available_payment_gateways();

                $Api_key = $available_gateways['ada_payment']->settings['Api_key'];
                $Url = $available_gateways['ada_payment']->settings['url'];
                $ExpirationTime = $available_gateways['ada_payment']->settings['expirationTime'];
                $sandbox = $available_gateways['ada_payment']->settings['sandbox'];


                //$order->update_status( 'on-hold',  __( 'Awaiting Ada Payment', 'ada-pay-woo') );

                // if ( $order->get_total() > 0 ) {
                //     Mark as on-hold (we're awaiting the cheque)
                // } else {
                //     $order->payment_complete();
                // }

               // $this->clear_payment_with_api();

                //$order->reduce_order_stock();

                //WC()->cart->empty_cart();


                $total_amount = $order->total * 1098901.098901099;

                $vars = [
			            'amount' => (int)$total_amount,
			            'paymentRequestExpirationTime' => (int)$ExpirationTime, 
			            'receiptEmail' => $order->billing_email,
			            //'returnUrl'=>"http://localhost/ada_new/index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&on=SIYC05&pm=2&Itemid=0&lang="
			            'returnUrl'=> $this->get_return_url( $order),

                ];


	              $curl = curl_init();
		          curl_setopt_array($curl, [
		          CURLOPT_URL => $Url.'/'.'payment-request',
		          CURLOPT_RETURNTRANSFER => true,
		          CURLOPT_ENCODING => "",
		          CURLOPT_MAXREDIRS => 10,
		          CURLOPT_TIMEOUT => 30,
		          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		          CURLOPT_CUSTOMREQUEST => "PUT",
		          CURLOPT_POSTFIELDS => json_encode($vars),
		          // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
		          CURLOPT_HTTPHEADER => [
		            "Authorization: Bearer ".$Api_key,
		           "Content-Type: application/json"
		          ],
		        ]);

		        $response = curl_exec($curl);
		        $data = json_decode($response);

                
                $_SESSION['uuid'] = $data->uuid;
                $_SESSION['order'] = $order;


		        if (isset($data)) {
	        
		            if ($data->statusCode  == 400 && wp_doing_ajax()) {

		            	$html =  "<h3> An error occurred while placing order! Error info: " . $data->message[0].  "</h3>";

							// Only print notices if not reloading the checkout, otherwise they're lost in the page reload.
							// if ( ! isset( WC()->session->reload_checkout ) ) {
							// 	$messages = wc_print_notices( true );
							// }

							$response = array(
								'result'   => $html,
								'messages' => isset( $html ) ? $html : '',
								'refresh'  => isset( WC()->session->refresh_totals ),
								'reload'   => isset( WC()->session->reload_checkout ),
							);

							unset( WC()->session->refresh_totals, WC()->session->reload_checkout );

							return wp_send_json( $response );

		            }else if ($data->statusCode  == 401 && wp_doing_ajax()) {

                        $html = "<h3> Please Check the API KEY or Url  ".$data->message."</h3>";

                        $response = array(
                                'result'   => $html,
                                'messages' => isset( $html ) ? $html : '',
                                'refresh'  => isset( WC()->session->refresh_totals ),
                                'reload'   => isset( WC()->session->reload_checkout ),
                            );

                            unset( WC()->session->refresh_totals, WC()->session->reload_checkout );

                            return wp_send_json( $response );


                        
                    } else {

                        if ($sandbox == 'yes') {

    		            	  $order->reduce_order_stock();
                              WC()->cart->empty_cart();

    		            	return array(
    		                    'result'   => 'success',
    		                    'redirect' => 'https://sandbox.adapay.finance/pay/'.$data->uuid,
    		                );
                            
                        }else{

                              $order->reduce_order_stock();
                              WC()->cart->empty_cart();

                            return array(
                                'result'   => 'success',
                                'redirect' => 'https://adapay.finance/pay/'.$data->uuid,
                            );

                        }

		            }
                }else{

                    $html = "<h3 style=color:red;> Please Check the Url in Payment configuration</h3>";

                    $response = array(
                            'result'   => $html,
                            'messages' => isset( $html ) ? $html : '',
                            'refresh'  => isset( WC()->session->refresh_totals ),
                            'reload'   => isset( WC()->session->reload_checkout ),
                        );

                    unset( WC()->session->refresh_totals, WC()->session->reload_checkout );

                    return wp_send_json( $response );
                }

                // return array(
                //     'result'   => 'success',
                //     'redirect' => $this->get_return_url( $order ),
                // );
            }

            // public function clear_payment_with_api() {

            // }

            public function thankyou_page(){
                if( $this->instructions ){
                    echo wpautop( $this->instructions );
                }
            }

           
               
        }
    }
}


add_filter( 'woocommerce_payment_gateways', 'add_to_ada_payment_gateway');
//add_action('woocommerce_before_thankyou','get_return_url1');
add_action( 'init', 'session_init' );

add_filter( 'woocommerce_thankyou_order_received_text', 'd4tw_custom_ty_msg');

        function add_to_ada_payment_gateway( $gateways ) {
                
            $gateways[] = 'WC_Ada_pay_Gateway';
            return $gateways;
        }

        function session_init() {
            if (!session_id()) {
            session_start();
            }
        }

        function d4tw_custom_ty_msg ( $thank_you_msg ) {

            try{

                $available_gateways = WC()->payment_gateways->get_available_payment_gateways();
                $Url = $available_gateways['ada_payment']->settings['url'];

                $req = [

                  'uuid' => $_SESSION['uuid'],
                  //'uuid'=>"851144a2-7d23-4a0a-9996-0e8378ff6e5e",

                ];

                  $curl = curl_init();
                  curl_setopt_array($curl, [
                  CURLOPT_URL => $Url."/payment-request/get-by-uuid",
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => "",
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 30,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => "POST",
                  CURLOPT_POSTFIELDS => json_encode($req),
                  // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
                  CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer".$method->api_key,
                   "Content-Type: application/json"
                  ],
                ]);

                $response = curl_exec($curl);
                $err = curl_error($curl);

                $data = json_decode($response);


                $status = $subStatus = '';
                if ($data->status == 'confirmed') {
                    $status = ucfirst($data->status);
                }elseif ($data->status == 'pending') {
                    $status = ucfirst($data->status);
                }elseif ($data->status == 'confirmed' && $data->subStatus == 'overpaid') {
                    $status = ucfirst($data->status);
                    $subStatus = ucfirst($data->subStatus);
                }elseif($data->status == 'expired'){
                    $status = ucfirst($data->status);
                }else{
                    $status = 'Your Payment not initiate yet please do the Payment';
                }


                // $html = [

                //     $message = 'Thank you. Your order has been received',
                //     $order_number = 'Order number:'.$_SESSION['order'],
                //     $status = $status,

                // ];
                //unset($_SESSION['uuid']);

                // echo "<pre>";
                // print_r($html);
                // die;

                return $status;

            }catch(Error $e){

                echo 'Something went Wrong: ',  $e->getMessage(), "\n";
            }
        }

?>
